# MPV Scripting

MPV running inside Plex and Plex HTPC can be extended via Lua scripts in this directory. For information on the mpv scripting API, please see [the manual](https://mpv.io/manual/master/).

## Exposed application data

Scripts can read a variety of data provided by Plex from mpv `user-data` sub-properties:

- `user-data/plex/playing-media` contains a variety of metadata about the file currently being played and the mechanisms being used to play it.
- `user-data/plex/user-access-token` contains an authentication token that can be used to communicate with the plex.tv service.
- `user-data/plex/client-id` contains the application's unique client identifier string, for use when communicating with Plex services and media servers.

## Available message commands

Plex apps handle some messages sent via the `script-message-to main <command> [args...]` [mpv command](https://mpv.io/manual/master/#command-interface-script-message-to):

- `plex-toggle-fullscreen` takes no arguments, and toggles fullscreen mode.
- `plex-ui-action` takes a list of host input command names. See the "Commands" section of the inputmaps.md file for more details.
- `plex-ui-show` takes up to one argument. If the argument is false, it hides the UI layer; if it's true (or absent), it shows it. If the argument is "cycle", it toggles UI visibility.

Note: These lists are subject to change in future versions of Plex apps. This file will be updated when changes occur.
